/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.uicontrols.expressionbuilder;

import filenet.vw.api.VWFieldDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.IVWDescriptionPanel;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWExpressionItem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class VWWorkflowGroupDescriptionPanel
extends JPanel
implements IVWDescriptionPanel {
    private VWToolbarBorder m_nameBorder = null;
    private JTextField m_name = null;
    private VWToolbarBorder m_descriptionBorder = null;
    private JTextArea m_description = null;
    private GridBagConstraints m_gbCons = null;
    private VWFieldDefinition m_fieldDefinition = null;
    private VWExpressionItem m_expressionItem = null;

    public void init() {
        this.setLayout(new GridBagLayout());
        this.m_gbCons = new GridBagConstraints();
        this.initControls();
    }

    public void setExpressionItem(VWExpressionItem item) {
        Object expressionItem;
        this.m_expressionItem = item;
        this.m_fieldDefinition = null;
        if (item != null && (expressionItem = item.getExpressionItem()) instanceof VWFieldDefinition) {
            this.m_fieldDefinition = (VWFieldDefinition)expressionItem;
        }
        this.reinitialize();
    }

    public String getExpressionItem() {
        String expressionItem = null;
        try {
            if (this.m_expressionItem != null) {
                expressionItem = this.m_expressionItem.toString();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return expressionItem;
    }

    private void initControls() {
        this.m_gbCons.anchor = 23;
        this.m_gbCons.fill = 2;
        this.m_gbCons.gridx = 0;
        this.m_gbCons.gridy = 0;
        this.m_gbCons.weightx = 1.0;
        this.m_gbCons.weighty = 0.0;
        this.m_gbCons.gridheight = 1;
        this.m_gbCons.gridwidth = 1;
        this.m_gbCons.insets = new Insets(0, 2, 0, 0);
        this.m_nameBorder = new VWToolbarBorder(VWResource.s_name);
        this.add((Component)this.m_nameBorder, this.m_gbCons);
        JPanel namePanel = this.m_nameBorder.getClientPanel();
        namePanel.setLayout(new GridLayout());
        this.m_name = new JTextField();
        this.m_name.setEditable(false);
        namePanel.add(this.m_name);
        this.m_gbCons.fill = 1;
        ++this.m_gbCons.gridy;
        this.m_gbCons.weighty = 1.0;
        this.m_descriptionBorder = new VWToolbarBorder(VWResource.s_description);
        this.add((Component)this.m_descriptionBorder, this.m_gbCons);
        JPanel descriptionPanel = this.m_descriptionBorder.getClientPanel();
        descriptionPanel.setLayout(new GridLayout());
        this.m_description = new JTextArea();
        this.m_description.setEditable(false);
        descriptionPanel.add(new JScrollPane(this.m_description));
    }

    private void reinitialize() {
        try {
            if (this.m_fieldDefinition != null) {
                this.m_name.setText(this.m_fieldDefinition.getName());
                this.m_description.setText(this.m_fieldDefinition.getDescription());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

